class AdvancedUserRecipe1289564332(BasicNewsRecipe):
    title          = u'Manchester Evening News'
    oldest_article = 2
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                    

    remove_tags_before = dict(id='content')
    remove_tags = [dict(attrs={'class':['articletools', 'secondary', 'google_skyscraper ad-container', 'google_banner ad-container', 'pager']}),
                            dict (id=['media-container', 'map', 'comments', 'footer', 'secondary', 'header', 'image-gallery', 'image-carousel','thread-template'])]
       



    feeds          = [(u'United', u'http://menmedia.co.uk/manchestereveningnews/sport/football/manchester_united/rss.xml')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup